#include "services/impl/MeetingInfoImpl.h"
#include "csfunified/featuresets/MeetingFeatureSet.h"
#include "services/impl/meetingmgr/MeetingMgrControllerImplMac.h"
#include "services/impl/meetingmgr/MeetingMgrControllerImplWin.h"

namespace CSFUnified {

MeetingInfoImpl::MeetingInfoImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory)
	: MeetingInfoBaseImpl(unifiedFactory)
{
}

MeetingInfoImpl::MeetingInfoImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory, bool offServicesDispatcher)
	: MeetingInfoBaseImpl(unifiedFactory, offServicesDispatcher)
{
}

MeetingInfoImpl::~MeetingInfoImpl()
{
}

bool MeetingInfoImpl::getIsInProgress()
{
	SMART_PTR_NS::shared_ptr<MeetingFeatureSet> spFeatureSet = this->unifiedFactory->getFeatureSet<MeetingFeatureSet>();
	return spFeatureSet->getMeetingMgrController()->isMeetingInProgress(meetingID);
}

}